<?php

$root = dirname( dirname( __DIR__ ) ) . '/backups';
$files = glob( "$root/msmwiki*.zip" );

if( !empty( $files ) ) {
	// Last file should be the latest backup
	$file = end( $files );
	$name = basename( $file );
	header( 'Content-type: application/zip' );
	header( 'Content-length: ' . filesize( $file ) );
	header( 'Pragma: no-cache' );
	header( 'Cache-Control: no-cache, must-revalidate' );
	header( 'Content-Disposition: attachment; filename="' . $name . '"' );

	$h = fopen( $file, 'rb' );
	fpassthru( $h );
	fclose( $h );
} else {
	header( 'Content-type: text/plain' );
	echo 'File not found.';
}
